/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    private static final String THROWABLE_RENDERER_TAG = "throwableRenderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String LOGGER = "logger";
    static final String LOGGER_REF = "logger-ref";
    static final String CATEGORY_FACTORY_TAG = "categoryFactory";
    static final String LOGGER_FACTORY_TAG = "loggerFactory";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String ROOT_REF = "root-ref";
    static final String LEVEL_TAG = "level";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String THRESHOLD_ATTR = "threshold";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    private static final String RESET_ATTR = "reset";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM;
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    protected LoggerFactory catFactory = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        ONE_STRING_PARAM = classArray;
    }

    protected Appender findAppenderByName(Document document, String string) {
        Appender appender = (Appender)this.appenderBag.get(string);
        if (appender != null) {
            return appender;
        }
        Element element = null;
        NodeList nodeList = document.getElementsByTagName(APPENDER_TAG);
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem(NAME_ATTR);
            if (string.equals(node2.getNodeValue())) {
                element = (Element)node;
                break;
            }
            ++n;
        }
        if (element == null) {
            LogLog.error("No appender named [" + string + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element);
        if (appender != null) {
            this.appenderBag.put(string, appender);
        }
        return appender;
    }

    protected Appender findAppenderByReference(Element element) {
        String string = this.subst(element.getAttribute(REF_ATTR));
        Document document = element.getOwnerDocument();
        return this.findAppenderByName(document, string);
    }

    private static void parseUnrecognizedElement(Object object, Element element, Properties properties) throws Exception {
        boolean bl = false;
        if (object instanceof UnrecognizedElementHandler) {
            bl = ((UnrecognizedElementHandler)object).parseUnrecognizedElement(element, properties);
        }
        if (!bl) {
            LogLog.warn("Unrecognized element " + element.getNodeName());
        }
    }

    private static void quietParseUnrecognizedElement(Object object, Element element, Properties properties) {
        try {
            DOMConfigurator.parseUnrecognizedElement(object, element, properties);
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException || exception instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Error in extension content: ", exception);
        }
    }

    protected Appender parseAppender(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        LogLog.debug("Class name: [" + string + ']');
        try {
            Object t = Loader.loadClass(string).newInstance();
            Appender appender = (Appender)t;
            PropertySetter propertySetter = new PropertySetter(appender);
            appender.setName(this.subst(element.getAttribute(NAME_ATTR)));
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    if (element2.getTagName().equals(PARAM_TAG)) {
                        this.setParameter(element2, propertySetter);
                    } else if (element2.getTagName().equals(LAYOUT_TAG)) {
                        appender.setLayout(this.parseLayout(element2));
                    } else if (element2.getTagName().equals(FILTER_TAG)) {
                        this.parseFilters(element2, appender);
                    } else if (element2.getTagName().equals(ERROR_HANDLER_TAG)) {
                        this.parseErrorHandler(element2, appender);
                    } else if (element2.getTagName().equals(APPENDER_REF_TAG)) {
                        String string2 = this.subst(element2.getAttribute(REF_ATTR));
                        if (appender instanceof AppenderAttachable) {
                            AppenderAttachable appenderAttachable = (AppenderAttachable)((Object)appender);
                            LogLog.debug("Attaching appender named [" + string2 + "] to appender named [" + appender.getName() + "].");
                            appenderAttachable.addAppender(this.findAppenderByReference(element2));
                        } else {
                            LogLog.error("Requesting attachment of appender named [" + string2 + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                        }
                    } else {
                        DOMConfigurator.parseUnrecognizedElement(t, element2, this.props);
                    }
                }
                ++n2;
            }
            propertySetter.activate();
            return appender;
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException || exception instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not create an Appender. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        ErrorHandler errorHandler;
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.log4j.spi.ErrorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((errorHandler = (ErrorHandler)OptionConverter.instantiateByClassName(string, clazz, null)) != null) {
            errorHandler.setAppender(appender);
            PropertySetter propertySetter = new PropertySetter(errorHandler);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Object object;
                    Element element2 = (Element)node;
                    String string2 = element2.getTagName();
                    if (string2.equals(PARAM_TAG)) {
                        this.setParameter(element2, propertySetter);
                    } else if (string2.equals(APPENDER_REF_TAG)) {
                        errorHandler.setBackupAppender(this.findAppenderByReference(element2));
                    } else if (string2.equals(LOGGER_REF)) {
                        object = element2.getAttribute(REF_ATTR);
                        Logger logger = this.catFactory == null ? this.repository.getLogger((String)object) : this.repository.getLogger((String)object, this.catFactory);
                        errorHandler.setLogger(logger);
                    } else if (string2.equals(ROOT_REF)) {
                        object = this.repository.getRootLogger();
                        errorHandler.setLogger((Logger)object);
                    } else {
                        DOMConfigurator.quietParseUnrecognizedElement(errorHandler, element2, this.props);
                    }
                }
                ++n2;
            }
            propertySetter.activate();
            appender.setErrorHandler(errorHandler);
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        Filter filter;
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.apache.log4j.spi.Filter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((filter = (Filter)OptionConverter.instantiateByClassName(string, clazz, null)) != null) {
            PropertySetter propertySetter = new PropertySetter(filter);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    String string2 = element2.getTagName();
                    if (string2.equals(PARAM_TAG)) {
                        this.setParameter(element2, propertySetter);
                    } else {
                        DOMConfigurator.quietParseUnrecognizedElement(filter, element2, this.props);
                    }
                }
                ++n2;
            }
            propertySetter.activate();
            LogLog.debug("Adding filter of type [" + filter.getClass() + "] to appender named [" + appender.getName() + "].");
            appender.addFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCategory(Element element) {
        Object object;
        Logger logger;
        String string = this.subst(element.getAttribute(NAME_ATTR));
        String string2 = this.subst(element.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(string2)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Logger.");
            logger = this.catFactory == null ? this.repository.getLogger(string) : this.repository.getLogger(string, this.catFactory);
        } else {
            LogLog.debug("Desired logger sub-class: [" + string2 + ']');
            try {
                object = Loader.loadClass(string2);
                Method method = ((Class)object).getMethod("getLogger", ONE_STRING_PARAM);
                logger = (Logger)method.invoke(null, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof InterruptedException || invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("Could not retrieve category [" + string + "]. Reported error follows.", invocationTargetException);
                return;
            }
            catch (Exception exception) {
                LogLog.error("Could not retrieve category [" + string + "]. Reported error follows.", exception);
                return;
            }
        }
        object = logger;
        synchronized (object) {
            boolean bl = OptionConverter.toBoolean(this.subst(element.getAttribute(ADDITIVITY_ATTR)), true);
            LogLog.debug("Setting [" + logger.getName() + "] additivity to [" + bl + "].");
            logger.setAdditivity(bl);
            this.parseChildrenOfLoggerElement(element, logger, false);
        }
    }

    protected void parseCategoryFactory(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(string)) {
            LogLog.error("Category Factory tag class attribute not found.");
            LogLog.debug("No Category Factory configured.");
        } else {
            Object object;
            LogLog.debug("Desired category factory: [" + string + ']');
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.apache.log4j.spi.LoggerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((object = OptionConverter.instantiateByClassName(string, clazz, null)) instanceof LoggerFactory) {
                this.catFactory = (LoggerFactory)object;
            } else {
                LogLog.error("Category Factory class " + string + " does not implement org.apache.log4j.LoggerFactory");
            }
            PropertySetter propertySetter = new PropertySetter(object);
            Element element2 = null;
            Node node = null;
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    element2 = (Element)node;
                    if (element2.getTagName().equals(PARAM_TAG)) {
                        this.setParameter(element2, propertySetter);
                    } else {
                        DOMConfigurator.quietParseUnrecognizedElement(object, element2, this.props);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRoot(Element element) {
        Logger logger;
        Logger logger2 = logger = this.repository.getRootLogger();
        synchronized (logger2) {
            this.parseChildrenOfLoggerElement(element, logger, true);
        }
    }

    protected void parseChildrenOfLoggerElement(Element element, Logger logger, boolean bl) {
        PropertySetter propertySetter = new PropertySetter(logger);
        logger.removeAllAppenders();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals(APPENDER_REF_TAG)) {
                    Element element3 = (Element)node;
                    Appender appender = this.findAppenderByReference(element3);
                    String string2 = this.subst(element3.getAttribute(REF_ATTR));
                    if (appender != null) {
                        LogLog.debug("Adding appender named [" + string2 + "] to category [" + logger.getName() + "].");
                    } else {
                        LogLog.debug("Appender named [" + string2 + "] not found.");
                    }
                    logger.addAppender(appender);
                } else if (string.equals(LEVEL_TAG)) {
                    this.parseLevel(element2, logger, bl);
                } else if (string.equals(PRIORITY_TAG)) {
                    this.parseLevel(element2, logger, bl);
                } else if (string.equals(PARAM_TAG)) {
                    this.setParameter(element2, propertySetter);
                } else {
                    DOMConfigurator.quietParseUnrecognizedElement(logger, element2, this.props);
                }
            }
            ++n2;
        }
        propertySetter.activate();
    }

    protected Layout parseLayout(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing layout of class: \"" + string + "\"");
        try {
            Object t = Loader.loadClass(string).newInstance();
            Layout layout = (Layout)t;
            PropertySetter propertySetter = new PropertySetter(layout);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    String string2 = element2.getTagName();
                    if (string2.equals(PARAM_TAG)) {
                        this.setParameter(element2, propertySetter);
                    } else {
                        DOMConfigurator.parseUnrecognizedElement(t, element2, this.props);
                    }
                }
                ++n2;
            }
            propertySetter.activate();
            return layout;
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException || exception instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not create the Layout. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseRenderer(Element element) {
        String string = this.subst(element.getAttribute(RENDERING_CLASS_ATTR));
        String string2 = this.subst(element.getAttribute(RENDERED_CLASS_ATTR));
        if (this.repository instanceof RendererSupport) {
            RendererMap.addRenderer((RendererSupport)((Object)this.repository), string2, string);
        }
    }

    protected ThrowableRenderer parseThrowableRenderer(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing throwableRenderer of class: \"" + string + "\"");
        try {
            Object t = Loader.loadClass(string).newInstance();
            ThrowableRenderer throwableRenderer = (ThrowableRenderer)t;
            PropertySetter propertySetter = new PropertySetter(throwableRenderer);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    String string2 = element2.getTagName();
                    if (string2.equals(PARAM_TAG)) {
                        this.setParameter(element2, propertySetter);
                    } else {
                        DOMConfigurator.parseUnrecognizedElement(t, element2, this.props);
                    }
                }
                ++n2;
            }
            propertySetter.activate();
            return throwableRenderer;
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException || exception instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not create the ThrowableRenderer. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseLevel(Element element, Logger logger, boolean bl) {
        String string = logger.getName();
        if (bl) {
            string = ROOT_TAG;
        }
        String string2 = this.subst(element.getAttribute(VALUE_ATTR));
        LogLog.debug("Level value for " + string + " is  [" + string2 + "].");
        if ("inherited".equalsIgnoreCase(string2) || "null".equalsIgnoreCase(string2)) {
            if (bl) {
                LogLog.error("Root level cannot be inherited. Ignoring directive.");
            } else {
                logger.setLevel(null);
            }
        } else {
            String string3 = this.subst(element.getAttribute(CLASS_ATTR));
            if (EMPTY_STR.equals(string3)) {
                logger.setLevel(OptionConverter.toLevel(string2, Level.DEBUG));
            } else {
                LogLog.debug("Desired Level sub-class: [" + string3 + ']');
                try {
                    Class clazz = Loader.loadClass(string3);
                    Method method = clazz.getMethod("toLevel", ONE_STRING_PARAM);
                    Level level = (Level)method.invoke(null, string2);
                    logger.setLevel(level);
                }
                catch (Exception exception) {
                    if (exception instanceof InterruptedException || exception instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    LogLog.error("Could not create level [" + string2 + "]. Reported error follows.", exception);
                    return;
                }
            }
        }
        LogLog.debug(String.valueOf(string) + " level set to " + logger.getLevel());
    }

    protected void setParameter(Element element, PropertySetter propertySetter) {
        String string = this.subst(element.getAttribute(NAME_ATTR));
        String string2 = element.getAttribute(VALUE_ATTR);
        string2 = this.subst(OptionConverter.convertSpecialChars(string2));
        propertySetter.setProperty(string, string2);
    }

    public static void configure(Element element) {
        DOMConfigurator dOMConfigurator = new DOMConfigurator();
        dOMConfigurator.doConfigure(element, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String string) {
        DOMConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String string, long l) {
        XMLWatchdog xMLWatchdog = new XMLWatchdog(string);
        xMLWatchdog.setDelay(l);
        xMLWatchdog.start();
    }

    public void doConfigure(final String string, LoggerRepository loggerRepository) {
        ParseAction parseAction = new ParseAction(){

            public Document parse(DocumentBuilder documentBuilder) throws SAXException, IOException {
                return documentBuilder.parse(new File(string));
            }

            public String toString() {
                return "file [" + string + "]";
            }
        };
        this.doConfigure(parseAction, loggerRepository);
    }

    public void doConfigure(final URL uRL, LoggerRepository loggerRepository) {
        ParseAction parseAction = new ParseAction(){

            public Document parse(DocumentBuilder documentBuilder) throws SAXException, IOException {
                Document document;
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                InputStream inputStream = uRLConnection.getInputStream();
                try {
                    InputSource inputSource = new InputSource(inputStream);
                    inputSource.setSystemId(uRL.toString());
                    document = documentBuilder.parse(inputSource);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return document;
            }

            public String toString() {
                return "url [" + uRL.toString() + "]";
            }
        };
        this.doConfigure(parseAction, loggerRepository);
    }

    public void doConfigure(final InputStream inputStream, LoggerRepository loggerRepository) throws FactoryConfigurationError {
        ParseAction parseAction = new ParseAction(){

            public Document parse(DocumentBuilder documentBuilder) throws SAXException, IOException {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId("dummy://log4j.dtd");
                return documentBuilder.parse(inputSource);
            }

            public String toString() {
                return "input stream [" + inputStream.toString() + "]";
            }
        };
        this.doConfigure(parseAction, loggerRepository);
    }

    public void doConfigure(final Reader reader, LoggerRepository loggerRepository) throws FactoryConfigurationError {
        ParseAction parseAction = new ParseAction(){

            public Document parse(DocumentBuilder documentBuilder) throws SAXException, IOException {
                InputSource inputSource = new InputSource(reader);
                inputSource.setSystemId("dummy://log4j.dtd");
                return documentBuilder.parse(inputSource);
            }

            public String toString() {
                return "reader [" + reader.toString() + "]";
            }
        };
        this.doConfigure(parseAction, loggerRepository);
    }

    protected void doConfigure(final InputSource inputSource, LoggerRepository loggerRepository) throws FactoryConfigurationError {
        if (inputSource.getSystemId() == null) {
            inputSource.setSystemId("dummy://log4j.dtd");
        }
        ParseAction parseAction = new ParseAction(){

            public Document parse(DocumentBuilder documentBuilder) throws SAXException, IOException {
                return documentBuilder.parse(inputSource);
            }

            public String toString() {
                return "input source [" + inputSource.toString() + "]";
            }
        };
        this.doConfigure(parseAction, loggerRepository);
    }

    private final void doConfigure(ParseAction parseAction, LoggerRepository loggerRepository) throws FactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = null;
        this.repository = loggerRepository;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty(dbfKey, null));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + documentBuilderFactory.getClass().getName());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            Exception exception = factoryConfigurationError.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", exception);
            throw factoryConfigurationError;
        }
        try {
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new SAXErrorHandler());
            documentBuilder.setEntityResolver(new Log4jEntityResolver());
            Document document = parseAction.parse(documentBuilder);
            this.parse(document.getDocumentElement());
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException || exception instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not parse " + parseAction.toString() + ".", exception);
        }
    }

    public void doConfigure(Element element, LoggerRepository loggerRepository) {
        this.repository = loggerRepository;
        this.parse(element);
    }

    public static void configure(String string) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(string, LogManager.getLoggerRepository());
    }

    public static void configure(URL uRL) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(uRL, LogManager.getLoggerRepository());
    }

    protected void parse(Element element) {
        String string;
        String string2 = element.getTagName();
        if (!string2.equals(CONFIGURATION_TAG)) {
            if (string2.equals(OLD_CONFIGURATION_TAG)) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String string3 = this.subst(element.getAttribute(INTERNAL_DEBUG_ATTR));
        LogLog.debug("debug attribute= \"" + string3 + "\".");
        if (!string3.equals(EMPTY_STR) && !string3.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string3, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String string4 = this.subst(element.getAttribute(RESET_ATTR));
        LogLog.debug("reset attribute= \"" + string4 + "\".");
        if (!EMPTY_STR.equals(string4) && OptionConverter.toBoolean(string4, false)) {
            this.repository.resetConfiguration();
        }
        if (!(string = this.subst(element.getAttribute(CONFIG_DEBUG_ATTR))).equals(EMPTY_STR) && !string.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string, true));
        }
        String string5 = this.subst(element.getAttribute(THRESHOLD_ATTR));
        LogLog.debug("Threshold =\"" + string5 + "\".");
        if (!EMPTY_STR.equals(string5) && !"null".equals(string5)) {
            this.repository.setThreshold(string5);
        }
        String string6 = null;
        Element element2 = null;
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            if (node.getNodeType() == 1 && ((string6 = (element2 = (Element)node).getTagName()).equals(CATEGORY_FACTORY_TAG) || string6.equals(LOGGER_FACTORY_TAG))) {
                this.parseCategoryFactory(element2);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                element2 = (Element)node;
                string6 = element2.getTagName();
                if (string6.equals(CATEGORY) || string6.equals(LOGGER)) {
                    this.parseCategory(element2);
                } else if (string6.equals(ROOT_TAG)) {
                    this.parseRoot(element2);
                } else if (string6.equals(RENDERER_TAG)) {
                    this.parseRenderer(element2);
                } else if (string6.equals(THROWABLE_RENDERER_TAG)) {
                    ThrowableRenderer throwableRenderer;
                    if (this.repository instanceof ThrowableRendererSupport && (throwableRenderer = this.parseThrowableRenderer(element2)) != null) {
                        ((ThrowableRendererSupport)((Object)this.repository)).setThrowableRenderer(throwableRenderer);
                    }
                } else if (!(string6.equals(APPENDER_TAG) || string6.equals(CATEGORY_FACTORY_TAG) || string6.equals(LOGGER_FACTORY_TAG))) {
                    DOMConfigurator.quietParseUnrecognizedElement(this.repository, element2, this.props);
                }
            }
            ++n2;
        }
    }

    protected String subst(String string) {
        return DOMConfigurator.subst(string, this.props);
    }

    public static String subst(String string, Properties properties) {
        try {
            return OptionConverter.substVars(string, properties);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.warn("Could not perform variable substitution.", illegalArgumentException);
            return string;
        }
    }

    public static void setParameter(Element element, PropertySetter propertySetter, Properties properties) {
        String string = DOMConfigurator.subst(element.getAttribute(NAME_ATTR), properties);
        String string2 = element.getAttribute(VALUE_ATTR);
        string2 = DOMConfigurator.subst(OptionConverter.convertSpecialChars(string2), properties);
        propertySetter.setProperty(string, string2);
    }

    public static Object parseElement(Element element, Properties properties, Class clazz) throws Exception {
        String string = DOMConfigurator.subst(element.getAttribute(CLASS_ATTR), properties);
        Object object = OptionConverter.instantiateByClassName(string, clazz, null);
        if (object != null) {
            PropertySetter propertySetter = new PropertySetter(object);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    String string2 = element2.getTagName();
                    if (string2.equals(PARAM_TAG)) {
                        DOMConfigurator.setParameter(element2, propertySetter, properties);
                    } else {
                        DOMConfigurator.parseUnrecognizedElement(object, element2, properties);
                    }
                }
                ++n2;
            }
            return object;
        }
        return null;
    }

    private static interface ParseAction {
        public Document parse(DocumentBuilder var1) throws SAXException, IOException;
    }
}

