/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.MDC;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.spi.ThrowableInformation;

public class LoggingEvent
implements Serializable {
    private static long startTime = System.currentTimeMillis();
    public final transient String fqnOfCategoryClass;
    private transient Category logger;
    public final String categoryName;
    public transient Priority level;
    private String ndc;
    private Hashtable mdcCopy;
    private boolean ndcLookupRequired = true;
    private boolean mdcCopyLookupRequired = true;
    private transient Object message;
    private String renderedMessage;
    private String threadName;
    private ThrowableInformation throwableInfo;
    public final long timeStamp;
    private LocationInfo locationInfo;
    static final long serialVersionUID = -868428216207166145L;
    static final Integer[] PARAM_ARRAY = new Integer[1];
    static final String TO_LEVEL = "toLevel";
    static final Class[] TO_LEVEL_PARAMS = new Class[]{Integer.TYPE};
    static final Hashtable methodCache = new Hashtable(3);
    static /* synthetic */ Class class$0;

    public LoggingEvent(String string, Category category, Priority priority, Object object, Throwable throwable) {
        this.fqnOfCategoryClass = string;
        this.logger = category;
        this.categoryName = category.getName();
        this.level = priority;
        this.message = object;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable, category);
        }
        this.timeStamp = System.currentTimeMillis();
    }

    public LoggingEvent(String string, Category category, long l, Priority priority, Object object, Throwable throwable) {
        this.fqnOfCategoryClass = string;
        this.logger = category;
        this.categoryName = category.getName();
        this.level = priority;
        this.message = object;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable, category);
        }
        this.timeStamp = l;
    }

    public LoggingEvent(String string, Category category, long l, Level level, Object object, String string2, ThrowableInformation throwableInformation, String string3, LocationInfo locationInfo, Map map) {
        this.fqnOfCategoryClass = string;
        this.logger = category;
        this.categoryName = category != null ? category.getName() : null;
        this.level = level;
        this.message = object;
        if (throwableInformation != null) {
            this.throwableInfo = throwableInformation;
        }
        this.timeStamp = l;
        this.threadName = string2;
        this.ndcLookupRequired = false;
        this.ndc = string3;
        this.locationInfo = locationInfo;
        this.mdcCopyLookupRequired = false;
        if (map != null) {
            this.mdcCopy = new Hashtable(map);
        }
    }

    public LocationInfo getLocationInformation() {
        if (this.locationInfo == null) {
            this.locationInfo = new LocationInfo(new Throwable(), this.fqnOfCategoryClass);
        }
        return this.locationInfo;
    }

    public Level getLevel() {
        return (Level)this.level;
    }

    public String getLoggerName() {
        return this.categoryName;
    }

    public Category getLogger() {
        return this.logger;
    }

    public Object getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return this.getRenderedMessage();
    }

    public String getNDC() {
        if (this.ndcLookupRequired) {
            this.ndcLookupRequired = false;
            this.ndc = NDC.get();
        }
        return this.ndc;
    }

    public Object getMDC(String string) {
        Object v;
        if (this.mdcCopy != null && (v = this.mdcCopy.get(string)) != null) {
            return v;
        }
        return MDC.get(string);
    }

    public void getMDCCopy() {
        if (this.mdcCopyLookupRequired) {
            this.mdcCopyLookupRequired = false;
            Hashtable hashtable = MDC.getContext();
            if (hashtable != null) {
                this.mdcCopy = (Hashtable)hashtable.clone();
            }
        }
    }

    public String getRenderedMessage() {
        if (this.renderedMessage == null && this.message != null) {
            if (this.message instanceof String) {
                this.renderedMessage = (String)this.message;
            } else {
                LoggerRepository loggerRepository = this.logger.getLoggerRepository();
                if (loggerRepository instanceof RendererSupport) {
                    RendererSupport rendererSupport = (RendererSupport)((Object)loggerRepository);
                    this.renderedMessage = rendererSupport.getRendererMap().findAndRender(this.message);
                } else {
                    this.renderedMessage = this.message.toString();
                }
            }
        }
        return this.renderedMessage;
    }

    public static long getStartTime() {
        return startTime;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public ThrowableInformation getThrowableInformation() {
        return this.throwableInfo;
    }

    public String[] getThrowableStrRep() {
        if (this.throwableInfo == null) {
            return null;
        }
        return this.throwableInfo.getThrowableStrRep();
    }

    private void readLevel(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        try {
            String string = (String)objectInputStream.readObject();
            if (string == null) {
                this.level = Level.toLevel(n);
            } else {
                Method method = (Method)methodCache.get(string);
                if (method == null) {
                    Class clazz = Loader.loadClass(string);
                    method = clazz.getDeclaredMethod(TO_LEVEL, TO_LEVEL_PARAMS);
                    methodCache.put(string, method);
                }
                this.level = (Level)method.invoke(null, (Object[])new Integer[]{new Integer(n)});
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof InterruptedException || invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.warn("Level deserialization failed, reverting to default.", invocationTargetException);
            this.level = Level.toLevel(n);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("Level deserialization failed, reverting to default.", noSuchMethodException);
            this.level = Level.toLevel(n);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Level deserialization failed, reverting to default.", illegalAccessException);
            this.level = Level.toLevel(n);
        }
        catch (RuntimeException runtimeException) {
            LogLog.warn("Level deserialization failed, reverting to default.", runtimeException);
            this.level = Level.toLevel(n);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.readLevel(objectInputStream);
        if (this.locationInfo == null) {
            this.locationInfo = new LocationInfo(null, null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getThreadName();
        this.getRenderedMessage();
        this.getNDC();
        this.getMDCCopy();
        this.getThrowableStrRep();
        objectOutputStream.defaultWriteObject();
        this.writeLevel(objectOutputStream);
    }

    private void writeLevel(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.level.toInt());
        Class<?> clazz = this.level.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.log4j.Level");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(clazz.getName());
        }
    }

    public final void setProperty(String string, String string2) {
        if (this.mdcCopy == null) {
            this.getMDCCopy();
        }
        if (this.mdcCopy == null) {
            this.mdcCopy = new Hashtable();
        }
        this.mdcCopy.put(string, string2);
    }

    public final String getProperty(String string) {
        Object object = this.getMDC(string);
        String string2 = null;
        if (object != null) {
            string2 = object.toString();
        }
        return string2;
    }

    public final boolean locationInformationExists() {
        return this.locationInfo != null;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public Set getPropertyKeySet() {
        return this.getProperties().keySet();
    }

    public Map getProperties() {
        this.getMDCCopy();
        Map map = this.mdcCopy == null ? new HashMap() : this.mdcCopy;
        return Collections.unmodifiableMap(map);
    }

    public String getFQNOfLoggerClass() {
        return this.fqnOfCategoryClass;
    }

    public Object removeProperty(String string) {
        if (this.mdcCopy == null) {
            this.getMDCCopy();
        }
        if (this.mdcCopy == null) {
            this.mdcCopy = new Hashtable();
        }
        return this.mdcCopy.remove(string);
    }
}

