/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.spi.LoggingEvent;

public class SocketAppender
extends AppenderSkeleton {
    public static final int DEFAULT_PORT = 4560;
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    String remoteHost;
    public static final String ZONE = "_log4j_obj_tcpconnect_appender.local.";
    InetAddress address;
    int port = 4560;
    ObjectOutputStream oos;
    int reconnectionDelay = 30000;
    boolean locationInfo = false;
    private String application;
    private Connector connector;
    int counter = 0;
    private static final int RESET_FREQUENCY = 1;
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;

    public SocketAppender() {
    }

    public SocketAppender(InetAddress inetAddress, int n) {
        this.address = inetAddress;
        this.remoteHost = inetAddress.getHostName();
        this.port = n;
        this.connect(inetAddress, n);
    }

    public SocketAppender(String string, int n) {
        this.port = n;
        this.address = SocketAppender.getAddressByName(string);
        this.remoteHost = string;
        this.connect(this.address, n);
    }

    public void activateOptions() {
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
            this.zeroConf.advertise();
        }
        this.connect(this.address, this.port);
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                if (iOException instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("Could not close oos.", iOException);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.connector.interrupted = true;
            this.connector = null;
        }
    }

    void connect(InetAddress inetAddress, int n) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket(inetAddress, n).getOutputStream());
        }
        catch (IOException iOException) {
            if (iOException instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            String string = "Could not connect to remote log4j server at [" + inetAddress.getHostName() + "].";
            if (this.reconnectionDelay > 0) {
                string = String.valueOf(string) + " We will try again later.";
                this.fireConnector();
            } else {
                string = String.valueOf(string) + " We are not retrying.";
                this.errorHandler.error(string, iOException, 0);
            }
            LogLog.error(string);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (loggingEvent == null) {
            return;
        }
        if (this.address == null) {
            this.errorHandler.error("No remote host is set for SocketAppender named \"" + this.name + "\".");
            return;
        }
        if (this.oos != null) {
            try {
                if (this.locationInfo) {
                    loggingEvent.getLocationInformation();
                }
                if (this.application != null) {
                    loggingEvent.setProperty("application", this.application);
                }
                loggingEvent.getNDC();
                loggingEvent.getThreadName();
                loggingEvent.getMDCCopy();
                loggingEvent.getRenderedMessage();
                loggingEvent.getThrowableStrRep();
                this.oos.writeObject(loggingEvent);
                this.oos.flush();
                if (++this.counter >= 1) {
                    this.counter = 0;
                    this.oos.reset();
                }
            }
            catch (IOException iOException) {
                if (iOException instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                this.oos = null;
                LogLog.warn("Detected problem with connection: " + iOException);
                if (this.reconnectionDelay > 0) {
                    this.fireConnector();
                }
                this.errorHandler.error("Detected problem with connection, not reconnecting.", iOException, 0);
            }
        }
    }

    public void setAdvertiseViaMulticastDNS(boolean bl) {
        this.advertiseViaMulticastDNS = bl;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    void fireConnector() {
        if (this.connector == null) {
            LogLog.debug("Starting a new connector thread.");
            this.connector = new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    static InetAddress getAddressByName(String string) {
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedIOException || exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not find address of [" + string + "].", exception);
            return null;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setRemoteHost(String string) {
        this.address = SocketAppender.getAddressByName(string);
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setApplication(String string) {
        this.application = string;
    }

    public String getApplication() {
        return this.application;
    }

    public void setReconnectionDelay(int n) {
        this.reconnectionDelay = n;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    class Connector
    extends Thread {
        boolean interrupted = false;

        Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                try {
                    Connector.sleep(SocketAppender.this.reconnectionDelay);
                    LogLog.debug("Attempting connection to " + SocketAppender.this.address.getHostName());
                    Socket socket = new Socket(SocketAppender.this.address, SocketAppender.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketAppender.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        SocketAppender.this.connector = null;
                        LogLog.debug("Connection established. Exiting connector thread.");
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    LogLog.debug("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException connectException) {
                    LogLog.debug("Remote host " + SocketAppender.this.address.getHostName() + " refused connection.");
                }
                catch (IOException iOException) {
                    if (iOException instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    LogLog.debug("Could not connect to " + SocketAppender.this.address.getHostName() + ". Exception is " + iOException);
                }
            }
        }
    }
}

