/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.spi.LoggingEvent;

public abstract class PatternConverter {
    public PatternConverter next;
    int min = -1;
    int max = Integer.MAX_VALUE;
    boolean leftAlign = false;
    static String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};

    protected PatternConverter() {
    }

    protected PatternConverter(FormattingInfo formattingInfo) {
        this.min = formattingInfo.min;
        this.max = formattingInfo.max;
        this.leftAlign = formattingInfo.leftAlign;
    }

    protected abstract String convert(LoggingEvent var1);

    public void format(StringBuffer stringBuffer, LoggingEvent loggingEvent) {
        String string = this.convert(loggingEvent);
        if (string == null) {
            if (this.min > 0) {
                this.spacePad(stringBuffer, this.min);
            }
            return;
        }
        int n = string.length();
        if (n > this.max) {
            stringBuffer.append(string.substring(n - this.max));
        } else if (n < this.min) {
            if (this.leftAlign) {
                stringBuffer.append(string);
                this.spacePad(stringBuffer, this.min - n);
            } else {
                this.spacePad(stringBuffer, this.min - n);
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(string);
        }
    }

    public void spacePad(StringBuffer stringBuffer, int n) {
        while (n >= 32) {
            stringBuffer.append(SPACES[5]);
            n -= 32;
        }
        int n2 = 4;
        while (n2 >= 0) {
            if ((n & 1 << n2) != 0) {
                stringBuffer.append(SPACES[n2]);
            }
            --n2;
        }
    }
}

