/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.spi.ThrowableRenderer;

public final class EnhancedThrowableRenderer
implements ThrowableRenderer {
    private Method getStackTraceMethod;
    private Method getClassNameMethod;
    static /* synthetic */ Class class$0;

    public EnhancedThrowableRenderer() {
        try {
            Class[] classArray = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Throwable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.getStackTraceMethod = clazz.getMethod("getStackTrace", classArray);
            Class<?> clazz2 = Class.forName("java.lang.StackTraceElement");
            this.getClassNameMethod = clazz2.getMethod("getClassName", classArray);
        }
        catch (Exception exception) {}
    }

    public String[] doRender(Throwable throwable) {
        if (this.getStackTraceMethod != null) {
            try {
                Object[] objectArray = null;
                Object[] objectArray2 = (Object[])this.getStackTraceMethod.invoke((Object)throwable, objectArray);
                String[] stringArray = new String[objectArray2.length + 1];
                stringArray[0] = throwable.toString();
                HashMap hashMap = new HashMap();
                int n = 0;
                while (n < objectArray2.length) {
                    stringArray[n + 1] = this.formatElement(objectArray2[n], hashMap);
                    ++n;
                }
                return stringArray;
            }
            catch (Exception exception) {}
        }
        return DefaultThrowableRenderer.render(throwable);
    }

    private String formatElement(Object object, Map map) {
        StringBuffer stringBuffer;
        block13: {
            stringBuffer = new StringBuffer("\tat ");
            stringBuffer.append(object);
            try {
                Object object2;
                Object object3;
                String string = this.getClassNameMethod.invoke(object, null).toString();
                Object v = map.get(string);
                if (v != null) {
                    stringBuffer.append(v);
                    break block13;
                }
                Class clazz = this.findClass(string);
                int n = stringBuffer.length();
                stringBuffer.append('[');
                try {
                    object3 = clazz.getProtectionDomain().getCodeSource();
                    if (object3 != null && (object2 = ((CodeSource)object3).getLocation()) != null) {
                        if ("file".equals(((URL)object2).getProtocol())) {
                            String string2 = ((URL)object2).getPath();
                            if (string2 != null) {
                                int n2 = string2.lastIndexOf(47);
                                int n3 = string2.lastIndexOf(File.separatorChar);
                                if (n3 > n2) {
                                    n2 = n3;
                                }
                                if (n2 <= 0 || n2 == string2.length() - 1) {
                                    stringBuffer.append(object2);
                                } else {
                                    stringBuffer.append(string2.substring(n2 + 1));
                                }
                            }
                        } else {
                            stringBuffer.append(object2);
                        }
                    }
                }
                catch (SecurityException securityException) {}
                stringBuffer.append(':');
                object3 = clazz.getPackage();
                if (object3 != null && (object2 = ((Package)object3).getImplementationVersion()) != null) {
                    stringBuffer.append((String)object2);
                }
                stringBuffer.append(']');
                map.put(string, stringBuffer.substring(n));
            }
            catch (Exception exception) {}
        }
        return stringBuffer.toString();
    }

    private Class findClass(String string) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return this.getClass().getClassLoader().loadClass(string);
            }
        }
    }
}

