/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.ArrayList;
import java.util.List;

public abstract class NameAbbreviator {
    private static final NameAbbreviator DEFAULT = new NOPAbbreviator();

    public static NameAbbreviator getAbbreviator(String string) {
        if (string.length() > 0) {
            String string2 = string.trim();
            if (string2.length() == 0) {
                return DEFAULT;
            }
            int n = 0;
            if (string2.length() > 0) {
                if (string2.charAt(0) == '-') {
                    ++n;
                }
                while (n < string2.length() && string2.charAt(n) >= '0' && string2.charAt(n) <= '9') {
                    ++n;
                }
            }
            if (n == string2.length()) {
                int n2 = Integer.parseInt(string2);
                if (n2 >= 0) {
                    return new MaxElementAbbreviator(n2);
                }
                return new DropElementAbbreviator(-n2);
            }
            ArrayList<PatternAbbreviatorFragment> arrayList = new ArrayList<PatternAbbreviatorFragment>(5);
            int n3 = 0;
            while (n3 < string2.length() && n3 >= 0) {
                int n4;
                int n5 = n3;
                if (string2.charAt(n3) == '*') {
                    n4 = Integer.MAX_VALUE;
                    ++n5;
                } else if (string2.charAt(n3) >= '0' && string2.charAt(n3) <= '9') {
                    n4 = string2.charAt(n3) - 48;
                    ++n5;
                } else {
                    n4 = 0;
                }
                char c = '\u0000';
                if (n5 < string2.length() && (c = string2.charAt(n5)) == '.') {
                    c = '\u0000';
                }
                arrayList.add(new PatternAbbreviatorFragment(n4, c));
                n3 = string2.indexOf(".", n3);
                if (n3 == -1) break;
                ++n3;
            }
            return new PatternAbbreviator(arrayList);
        }
        return DEFAULT;
    }

    public static NameAbbreviator getDefaultAbbreviator() {
        return DEFAULT;
    }

    public abstract void abbreviate(int var1, StringBuffer var2);

    private static class DropElementAbbreviator
    extends NameAbbreviator {
        private final int count;

        public DropElementAbbreviator(int n) {
            this.count = n;
        }

        public void abbreviate(int n, StringBuffer stringBuffer) {
            int n2 = this.count;
            int n3 = stringBuffer.indexOf(".", n);
            while (n3 != -1) {
                if (--n2 == 0) {
                    stringBuffer.delete(n, n3 + 1);
                    break;
                }
                n3 = stringBuffer.indexOf(".", n3 + 1);
            }
        }
    }

    private static class MaxElementAbbreviator
    extends NameAbbreviator {
        private final int count;

        public MaxElementAbbreviator(int n) {
            this.count = n;
        }

        public void abbreviate(int n, StringBuffer stringBuffer) {
            int n2 = stringBuffer.length() - 1;
            String string = stringBuffer.toString();
            int n3 = this.count;
            while (n3 > 0) {
                if ((n2 = string.lastIndexOf(".", n2 - 1)) == -1 || n2 < n) {
                    return;
                }
                --n3;
            }
            stringBuffer.delete(n, n2 + 1);
        }
    }

    private static class NOPAbbreviator
    extends NameAbbreviator {
        public void abbreviate(int n, StringBuffer stringBuffer) {
        }
    }

    private static class PatternAbbreviator
    extends NameAbbreviator {
        private final PatternAbbreviatorFragment[] fragments;

        public PatternAbbreviator(List list) {
            if (list.size() == 0) {
                throw new IllegalArgumentException("fragments must have at least one element");
            }
            this.fragments = new PatternAbbreviatorFragment[list.size()];
            list.toArray(this.fragments);
        }

        public void abbreviate(int n, StringBuffer stringBuffer) {
            int n2 = n;
            int n3 = 0;
            while (n3 < this.fragments.length - 1 && n2 < stringBuffer.length()) {
                n2 = this.fragments[n3].abbreviate(stringBuffer, n2);
                ++n3;
            }
            PatternAbbreviatorFragment patternAbbreviatorFragment = this.fragments[this.fragments.length - 1];
            while (n2 < stringBuffer.length() && n2 >= 0) {
                n2 = patternAbbreviatorFragment.abbreviate(stringBuffer, n2);
            }
        }
    }

    private static class PatternAbbreviatorFragment {
        private final int charCount;
        private final char ellipsis;

        public PatternAbbreviatorFragment(int n, char c) {
            this.charCount = n;
            this.ellipsis = c;
        }

        public int abbreviate(StringBuffer stringBuffer, int n) {
            int n2 = stringBuffer.toString().indexOf(".", n);
            if (n2 != -1) {
                if (n2 - n > this.charCount) {
                    stringBuffer.delete(n + this.charCount, n2);
                    n2 = n + this.charCount;
                    if (this.ellipsis != '\u0000') {
                        stringBuffer.insert(n2, this.ellipsis);
                        ++n2;
                    }
                }
                ++n2;
            }
            return n2;
        }
    }
}

