/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;

public class SocketServer {
    static String GENERIC = "generic";
    static String CONFIG_FILE_EXT = ".lcf";
    static Logger cat;
    static SocketServer server;
    static int port;
    Hashtable hierarchyMap;
    LoggerRepository genericHierarchy;
    File dir;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.log4j.net.SocketServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Logger.getLogger(clazz);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 3) {
            SocketServer.init(stringArray[0], stringArray[1], stringArray[2]);
        } else {
            SocketServer.usage("Wrong number of arguments.");
        }
        try {
            cat.info("Listening on port " + port);
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                cat.info("Waiting to accept a new client.");
                Socket socket = serverSocket.accept();
                InetAddress inetAddress = socket.getInetAddress();
                cat.info("Connected to client at " + inetAddress);
                LoggerRepository loggerRepository = (LoggerRepository)SocketServer.server.hierarchyMap.get(inetAddress);
                if (loggerRepository == null) {
                    loggerRepository = server.configureHierarchy(inetAddress);
                }
                cat.info("Starting new socket node.");
                new Thread(new SocketNode(socket, loggerRepository)).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static void usage(String string) {
        System.err.println(string);
        StringBuffer stringBuffer = new StringBuffer("Usage: java ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.log4j.net.SocketServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" port configFile directory").toString());
        System.exit(1);
    }

    static void init(String string, String string2, String string3) {
        try {
            port = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            SocketServer.usage("Could not interpret port number [" + string + "].");
        }
        PropertyConfigurator.configure(string2);
        File file = new File(string3);
        if (!file.isDirectory()) {
            SocketServer.usage("[" + string3 + "] is not a directory.");
        }
        server = new SocketServer(file);
    }

    public SocketServer(File file) {
        this.dir = file;
        this.hierarchyMap = new Hashtable(11);
    }

    LoggerRepository configureHierarchy(InetAddress inetAddress) {
        cat.info("Locating configuration file for " + inetAddress);
        String string = inetAddress.toString();
        int n = string.indexOf("/");
        if (n == -1) {
            cat.warn("Could not parse the inetAddress [" + inetAddress + "]. Using default hierarchy.");
            return this.genericHierarchy();
        }
        String string2 = string.substring(0, n);
        File file = new File(this.dir, String.valueOf(string2) + CONFIG_FILE_EXT);
        if (file.exists()) {
            Hierarchy hierarchy = new Hierarchy(new RootLogger(Level.DEBUG));
            this.hierarchyMap.put(inetAddress, hierarchy);
            new PropertyConfigurator().doConfigure(file.getAbsolutePath(), (LoggerRepository)hierarchy);
            return hierarchy;
        }
        cat.warn("Could not find config file [" + file + "].");
        return this.genericHierarchy();
    }

    LoggerRepository genericHierarchy() {
        if (this.genericHierarchy == null) {
            File file = new File(this.dir, String.valueOf(GENERIC) + CONFIG_FILE_EXT);
            if (file.exists()) {
                this.genericHierarchy = new Hierarchy(new RootLogger(Level.DEBUG));
                new PropertyConfigurator().doConfigure(file.getAbsolutePath(), this.genericHierarchy);
            } else {
                cat.warn("Could not find config file [" + file + "]. Will use the default hierarchy.");
                this.genericHierarchy = LogManager.getLoggerRepository();
            }
        }
        return this.genericHierarchy;
    }
}

