/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private ServerMonitor serverMonitor = null;
    private boolean locationInfo = false;
    private CyclicBuffer buffer = null;
    private String application;
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;
    public static final String ZONE = "_log4j_obj_tcpaccept_appender.local.";
    private ServerSocket serverSocket;

    public SocketHubAppender() {
    }

    public SocketHubAppender(int n) {
        this.port = n;
        this.startServer();
    }

    public void activateOptions() {
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
            this.zeroConf.advertise();
        }
        this.startServer();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("closing SocketHubAppender " + this.getName());
        this.closed = true;
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
        this.cleanUp();
        LogLog.debug("SocketHubAppender " + this.getName() + " closed");
    }

    public void cleanUp() {
        LogLog.debug("stopping ServerSocket");
        this.serverMonitor.stopMonitor();
        this.serverMonitor = null;
        LogLog.debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(0);
            if (objectOutputStream == null) continue;
            try {
                objectOutputStream.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
                LogLog.error("could not close oos.", interruptedIOException);
            }
            catch (IOException iOException) {
                LogLog.error("could not close oos.", iOException);
            }
            this.oosList.removeElementAt(0);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (loggingEvent != null) {
            if (this.locationInfo) {
                loggingEvent.getLocationInformation();
            }
            if (this.application != null) {
                loggingEvent.setProperty("application", this.application);
            }
            loggingEvent.getNDC();
            loggingEvent.getThreadName();
            loggingEvent.getMDCCopy();
            loggingEvent.getRenderedMessage();
            loggingEvent.getThrowableStrRep();
            if (this.buffer != null) {
                this.buffer.add(loggingEvent);
            }
        }
        if (loggingEvent == null || this.oosList.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.oosList.size()) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            if (objectOutputStream == null) break;
            try {
                objectOutputStream.writeObject(loggingEvent);
                objectOutputStream.flush();
                objectOutputStream.reset();
            }
            catch (IOException iOException) {
                if (iOException instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                this.oosList.removeElementAt(n);
                LogLog.debug("dropped connection");
                --n;
            }
            ++n;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setApplication(String string) {
        this.application = string;
    }

    public String getApplication() {
        return this.application;
    }

    public int getPort() {
        return this.port;
    }

    public void setBufferSize(int n) {
        this.buffer = new CyclicBuffer(n);
    }

    public int getBufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getMaxSize();
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setAdvertiseViaMulticastDNS(boolean bl) {
        this.advertiseViaMulticastDNS = bl;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    private void startServer() {
        this.serverMonitor = new ServerMonitor(this.port, this.oosList);
    }

    protected ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n);
    }

    private class ServerMonitor
    implements Runnable {
        private int port;
        private Vector oosList;
        private boolean keepRunning;
        private Thread monitorThread;

        public ServerMonitor(int n, Vector vector) {
            this.port = n;
            this.oosList = vector;
            this.keepRunning = true;
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.setName("SocketHubAppender-Monitor-" + this.port);
            this.monitorThread.start();
        }

        public synchronized void stopMonitor() {
            if (this.keepRunning) {
                LogLog.debug("server monitor thread shutting down");
                this.keepRunning = false;
                try {
                    if (SocketHubAppender.this.serverSocket != null) {
                        SocketHubAppender.this.serverSocket.close();
                        SocketHubAppender.this.serverSocket = null;
                    }
                }
                catch (IOException iOException) {}
                try {
                    this.monitorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.monitorThread = null;
                LogLog.debug("server monitor thread shut down");
            }
        }

        private void sendCachedEvents(ObjectOutputStream objectOutputStream) throws IOException {
            if (SocketHubAppender.this.buffer != null) {
                int n = 0;
                while (n < SocketHubAppender.this.buffer.length()) {
                    objectOutputStream.writeObject(SocketHubAppender.this.buffer.get(n));
                    ++n;
                }
                objectOutputStream.flush();
                objectOutputStream.reset();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SocketHubAppender.access$1(SocketHubAppender.this, null);
            try {
                SocketHubAppender.access$1(SocketHubAppender.this, SocketHubAppender.this.createServerSocket(this.port));
                SocketHubAppender.access$0(SocketHubAppender.this).setSoTimeout(1000);
            }
            catch (Exception var1_1) {
                if (var1_1 instanceof InterruptedIOException || var1_1 instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("exception setting timeout, shutting down server socket.", var1_1);
                this.keepRunning = false;
                return;
            }
            try {
                try {
                    SocketHubAppender.access$0(SocketHubAppender.this).setSoTimeout(1000);
                }
                catch (SocketException var1_2) {
                    LogLog.error("exception setting timeout, shutting down server socket.", var1_2);
                    var4_4 = null;
                    try {
                        SocketHubAppender.access$0(SocketHubAppender.this).close();
                        return;
                    }
                    catch (InterruptedIOException v0) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (IOException v1) {}
                    return;
                }
                while (this.keepRunning) {
                    var1_3 = null;
                    try {
                        var1_3 = SocketHubAppender.access$0(SocketHubAppender.this).accept();
                    }
                    catch (InterruptedIOException v2) {
                    }
                    catch (SocketException var2_8) {
                        LogLog.error("exception accepting socket, shutting down server socket.", var2_8);
                        this.keepRunning = false;
                    }
                    catch (IOException var2_9) {
                        LogLog.error("exception accepting socket.", var2_9);
                    }
                    if (var1_3 == null) continue;
                    try {
                        var2_7 = var1_3.getInetAddress();
                        LogLog.debug("accepting connection from " + var2_7.getHostName() + " (" + var2_7.getHostAddress() + ")");
                        var3_11 = new ObjectOutputStream(var1_3.getOutputStream());
                        if (SocketHubAppender.access$2(SocketHubAppender.this) != null && SocketHubAppender.access$2(SocketHubAppender.this).length() > 0) {
                            this.sendCachedEvents(var3_11);
                        }
                        this.oosList.addElement(var3_11);
                    }
                    catch (IOException var2_10) {
                        if (var2_10 instanceof InterruptedIOException) {
                            Thread.currentThread().interrupt();
                        }
                        LogLog.error("exception creating output stream on socket.", var2_10);
                    }
                }
            }
            catch (Throwable var5_12) {
                var4_5 = null;
                ** try [egrp 5[TRYBLOCK] [9, 10 : 283->296)] { 
lbl60:
                // 1 sources

                SocketHubAppender.access$0(SocketHubAppender.this).close();
                throw var5_12;
lbl62:
                // 1 sources

                catch (InterruptedIOException v3) {
                    Thread.currentThread().interrupt();
                    throw var5_12;
                }
lbl65:
                // 1 sources

                catch (IOException v4) {}
                throw var5_12;
            }
            {
                var4_6 = null;
            }
            ** try [egrp 5[TRYBLOCK] [9, 10 : 283->296)] { 
lbl69:
            // 1 sources

            SocketHubAppender.access$0(SocketHubAppender.this).close();
            return;
lbl71:
            // 1 sources

            catch (InterruptedIOException v5) {
                Thread.currentThread().interrupt();
                return;
            }
lbl74:
            // 1 sources

            catch (IOException v6) {
                return;
            }
        }
    }
}

