/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeEditor;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeRenderer;

public class CategoryImmediateEditor
extends DefaultTreeCellEditor {
    private CategoryNodeRenderer renderer;
    protected Icon editingIcon = null;

    public CategoryImmediateEditor(JTree jTree, CategoryNodeRenderer categoryNodeRenderer, CategoryNodeEditor categoryNodeEditor) {
        super(jTree, categoryNodeRenderer, categoryNodeEditor);
        this.renderer = categoryNodeRenderer;
        categoryNodeRenderer.setIcon(null);
        categoryNodeRenderer.setLeafIcon(null);
        categoryNodeRenderer.setOpenIcon(null);
        categoryNodeRenderer.setClosedIcon(null);
        ((DefaultTreeCellEditor)this).editingIcon = null;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = false;
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            CategoryNode categoryNode = (CategoryNode)treePath.getLastPathComponent();
            bl = categoryNode.isLeaf();
        }
        return bl;
    }

    public boolean inCheckBoxHitRegion(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return false;
        }
        CategoryNode cfr_ignored_0 = (CategoryNode)treePath.getLastPathComponent();
        Rectangle rectangle = this.tree.getRowBounds(this.lastRow);
        Dimension dimension = this.renderer.getCheckBoxOffset();
        rectangle.translate(this.offset + dimension.width, dimension.height);
        rectangle.contains(mouseEvent.getPoint());
        return true;
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        boolean bl = false;
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            bl = this.inCheckBoxHitRegion(mouseEvent);
        }
        return bl;
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.offset = 0;
    }
}

