/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class JDBCAppender
extends AppenderSkeleton
implements Appender {
    protected String databaseURL = "jdbc:odbc:myDB";
    protected String databaseUser = "me";
    protected String databasePassword = "mypassword";
    protected Connection connection = null;
    protected String sqlStatement = "";
    protected int bufferSize = 1;
    protected ArrayList buffer = new ArrayList(this.bufferSize);
    protected ArrayList removes = new ArrayList(this.bufferSize);
    private boolean locationInfo = false;

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public void append(LoggingEvent loggingEvent) {
        loggingEvent.getNDC();
        loggingEvent.getThreadName();
        loggingEvent.getMDCCopy();
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        loggingEvent.getRenderedMessage();
        loggingEvent.getThrowableStrRep();
        this.buffer.add(loggingEvent);
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
    }

    protected String getLogStatement(LoggingEvent loggingEvent) {
        return this.getLayout().format(loggingEvent);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(String string) throws SQLException {
        Connection connection;
        block4: {
            connection = null;
            Statement statement = null;
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(string);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (statement != null) {
                    statement.close();
                }
                this.closeConnection(connection);
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (statement == null) break block4;
            }
            statement.close();
        }
        this.closeConnection(connection);
    }

    protected void closeConnection(Connection connection) {
    }

    protected Connection getConnection() throws SQLException {
        if (!DriverManager.getDrivers().hasMoreElements()) {
            this.setDriver("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        if (this.connection == null) {
            this.connection = DriverManager.getConnection(this.databaseURL, this.databaseUser, this.databasePassword);
        }
        return this.connection;
    }

    public void close() {
        this.flushBuffer();
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            this.errorHandler.error("Error closing connection", sQLException, 0);
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushBuffer() {
        this.removes.ensureCapacity(this.buffer.size());
        Iterator iterator = this.buffer.iterator();
        while (true) {
            Object var4_5;
            if (!iterator.hasNext()) {
                this.buffer.removeAll(this.removes);
                this.removes.clear();
                return;
            }
            LoggingEvent loggingEvent = (LoggingEvent)iterator.next();
            try {
                try {
                    String string = this.getLogStatement(loggingEvent);
                    this.execute(string);
                }
                catch (SQLException sQLException) {
                    this.errorHandler.error("Failed to excute sql", sQLException, 2);
                }
            }
            catch (Throwable throwable) {
                var4_5 = null;
                this.removes.add(loggingEvent);
                throw throwable;
            }
            {
                var4_5 = null;
                this.removes.add(loggingEvent);
            }
        }
    }

    public void finalize() {
        this.close();
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setSql(String string) {
        this.sqlStatement = string;
        if (this.getLayout() == null) {
            this.setLayout(new PatternLayout(string));
        } else {
            ((PatternLayout)this.getLayout()).setConversionPattern(string);
        }
    }

    public String getSql() {
        return this.sqlStatement;
    }

    public void setUser(String string) {
        this.databaseUser = string;
    }

    public void setURL(String string) {
        this.databaseURL = string;
    }

    public void setPassword(String string) {
        this.databasePassword = string;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
        this.buffer.ensureCapacity(this.bufferSize);
        this.removes.ensureCapacity(this.bufferSize);
    }

    public String getUser() {
        return this.databaseUser;
    }

    public String getURL() {
        return this.databaseURL;
    }

    public String getPassword() {
        return this.databasePassword;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setDriver(String string) {
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            this.errorHandler.error("Failed to load driver", exception, 0);
        }
    }
}

