/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.chainsaw.EventDetails;

class MyTableModel
extends AbstractTableModel {
    private static final Logger LOG;
    private static final Comparator MY_COMP;
    private static final String[] COL_NAMES;
    private static final EventDetails[] EMPTY_LIST;
    private static final DateFormat DATE_FORMATTER;
    private final Object mLock = new Object();
    private final SortedSet mAllEvents = new TreeSet(MY_COMP);
    private EventDetails[] mFilteredEvents = EMPTY_LIST;
    private final List mPendingEvents = new ArrayList();
    private boolean mPaused = false;
    private String mThreadFilter = "";
    private String mMessageFilter = "";
    private String mNDCFilter = "";
    private String mCategoryFilter = "";
    private Priority mPriorityFilter = Priority.DEBUG;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.log4j.chainsaw.MyTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger(clazz);
        MY_COMP = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == null && object2 == null) {
                    return 0;
                }
                if (object == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                EventDetails eventDetails = (EventDetails)object;
                EventDetails eventDetails2 = (EventDetails)object2;
                if (eventDetails.getTimeStamp() < eventDetails2.getTimeStamp()) {
                    return 1;
                }
                return -1;
            }
        };
        COL_NAMES = new String[]{"Time", "Priority", "Trace", "Category", "NDC", "Message"};
        EMPTY_LIST = new EventDetails[0];
        DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 2);
    }

    MyTableModel() {
        Thread thread = new Thread(new Processor());
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents.length;
        }
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int n) {
        return COL_NAMES[n];
    }

    public Class getColumnClass(int n) {
        Class<?> clazz;
        block5: {
            block6: {
                if (n != 2) break block6;
                clazz = class$1;
                if (clazz != null) break block5;
                try {
                    clazz = class$1 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                break block5;
            }
            clazz = class$2;
            if (clazz == null) {
                try {
                    class$2 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$2;
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails eventDetails = this.mFilteredEvents[n];
            if (n2 == 0) {
                return DATE_FORMATTER.format(new Date(eventDetails.getTimeStamp()));
            }
            if (n2 == 1) {
                return eventDetails.getPriority();
            }
            if (n2 == 2) {
                return eventDetails.getThrowableStrRep() == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (n2 == 3) {
                return eventDetails.getCategoryName();
            }
            if (n2 == 4) {
                return eventDetails.getNDC();
            }
            return eventDetails.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriorityFilter(Priority priority) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPriorityFilter = priority;
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mThreadFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMessageFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNDCFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNDCFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCategoryFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCategoryFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventDetails eventDetails) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingEvents.add(eventDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllEvents.clear();
            this.mFilteredEvents = new EventDetails[0];
            this.mPendingEvents.clear();
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggle() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPaused = !this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDetails getEventDetails(int n) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents[n];
        }
    }

    private void updateFilteredEvents(boolean bl) {
        EventDetails eventDetails;
        long l = System.currentTimeMillis();
        ArrayList<EventDetails> arrayList = new ArrayList<EventDetails>();
        int n = this.mAllEvents.size();
        Iterator iterator = this.mAllEvents.iterator();
        while (iterator.hasNext()) {
            eventDetails = (EventDetails)iterator.next();
            if (!this.matchFilter(eventDetails)) continue;
            arrayList.add(eventDetails);
        }
        eventDetails = this.mFilteredEvents.length == 0 ? null : this.mFilteredEvents[0];
        this.mFilteredEvents = arrayList.toArray(EMPTY_LIST);
        if (bl && eventDetails != null) {
            int n2 = arrayList.indexOf(eventDetails);
            if (n2 < 1) {
                LOG.warn("In strange state");
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, n2 - 1);
            }
        } else {
            this.fireTableDataChanged();
        }
        long l2 = System.currentTimeMillis();
        LOG.debug("Total time [ms]: " + (l2 - l) + " in update, size: " + n);
    }

    private boolean matchFilter(EventDetails eventDetails) {
        if (eventDetails.getPriority().isGreaterOrEqual(this.mPriorityFilter) && eventDetails.getThreadName().indexOf(this.mThreadFilter) >= 0 && eventDetails.getCategoryName().indexOf(this.mCategoryFilter) >= 0 && (this.mNDCFilter.length() == 0 || eventDetails.getNDC() != null && eventDetails.getNDC().indexOf(this.mNDCFilter) >= 0)) {
            String string = eventDetails.getMessage();
            if (string == null) {
                return this.mMessageFilter.length() == 0;
            }
            return string.indexOf(this.mMessageFilter) >= 0;
        }
        return false;
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                Object object = MyTableModel.this.mLock;
                synchronized (object) {
                    if (MyTableModel.this.mPaused) {
                        continue;
                    }
                    boolean bl = true;
                    boolean bl2 = false;
                    Iterator iterator = MyTableModel.this.mPendingEvents.iterator();
                    while (iterator.hasNext()) {
                        EventDetails eventDetails = (EventDetails)iterator.next();
                        MyTableModel.this.mAllEvents.add(eventDetails);
                        bl = bl && eventDetails == MyTableModel.this.mAllEvents.first();
                        boolean bl3 = bl2 = bl2 || MyTableModel.this.matchFilter(eventDetails);
                    }
                    MyTableModel.this.mPendingEvents.clear();
                    if (bl2) {
                        MyTableModel.this.updateFilteredEvents(bl);
                    }
                }
            }
        }
    }
}

