/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.NameValue;
import org.apache.log4j.PropertyWatchdog;
import org.apache.log4j.SortedKeyEnumeration;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;

public class PropertyConfigurator
implements Configurator {
    protected Hashtable registry = new Hashtable(11);
    private LoggerRepository repository;
    protected LoggerFactory loggerFactory = new DefaultCategoryFactory();
    static final String CATEGORY_PREFIX = "log4j.category.";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String FACTORY_PREFIX = "log4j.factory";
    static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    static final String ROOT_CATEGORY_PREFIX = "log4j.rootCategory";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String APPENDER_PREFIX = "log4j.appender.";
    static final String RENDERER_PREFIX = "log4j.renderer.";
    static final String THRESHOLD_PREFIX = "log4j.threshold";
    private static final String THROWABLE_RENDERER_PREFIX = "log4j.throwableRenderer";
    private static final String LOGGER_REF = "logger-ref";
    private static final String ROOT_REF = "root-ref";
    private static final String APPENDER_REF_TAG = "appender-ref";
    public static final String LOGGER_FACTORY_KEY = "log4j.loggerFactory";
    private static final String RESET_KEY = "log4j.reset";
    private static final String INTERNAL_ROOT_NAME = "root";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    /*
     * Exception decompiling
     */
    public void doConfigure(String var1_1, LoggerRepository var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 149->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void configure(String string) {
        new PropertyConfigurator().doConfigure(string, LogManager.getLoggerRepository());
    }

    public static void configure(URL uRL) {
        new PropertyConfigurator().doConfigure(uRL, LogManager.getLoggerRepository());
    }

    public static void configure(InputStream inputStream) {
        new PropertyConfigurator().doConfigure(inputStream, LogManager.getLoggerRepository());
    }

    public static void configure(Properties properties) {
        new PropertyConfigurator().doConfigure(properties, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String string) {
        PropertyConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String string, long l) {
        PropertyWatchdog propertyWatchdog = new PropertyWatchdog(string);
        propertyWatchdog.setDelay(l);
        propertyWatchdog.start();
    }

    public void doConfigure(Properties properties, LoggerRepository loggerRepository) {
        String string;
        String string2;
        this.repository = loggerRepository;
        String string3 = properties.getProperty("log4j.debug");
        if (string3 == null && (string3 = properties.getProperty("log4j.configDebug")) != null) {
            LogLog.warn("[log4j.configDebug] is deprecated. Use [log4j.debug] instead.");
        }
        if (string3 != null) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string3, true));
        }
        if ((string2 = properties.getProperty(RESET_KEY)) != null && OptionConverter.toBoolean(string2, false)) {
            loggerRepository.resetConfiguration();
        }
        if ((string = OptionConverter.findAndSubst(THRESHOLD_PREFIX, properties)) != null) {
            loggerRepository.setThreshold(OptionConverter.toLevel(string, Level.ALL));
            LogLog.debug("Hierarchy threshold set to [" + loggerRepository.getThreshold() + "].");
        }
        this.configureRootCategory(properties, loggerRepository);
        this.configureLoggerFactory(properties);
        this.parseCatsAndRenderers(properties, loggerRepository);
        LogLog.debug("Finished configuring.");
        this.registry.clear();
    }

    public void doConfigure(InputStream inputStream, LoggerRepository loggerRepository) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            if (iOException instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not read configuration file from InputStream [" + inputStream + "].", iOException);
            LogLog.error("Ignoring configuration InputStream [" + inputStream + "].");
            return;
        }
        this.doConfigure(properties, loggerRepository);
    }

    /*
     * Exception decompiling
     */
    public void doConfigure(URL var1_1, LoggerRepository var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 181->184)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void configureLoggerFactory(Properties properties) {
        String string = OptionConverter.findAndSubst(LOGGER_FACTORY_KEY, properties);
        if (string != null) {
            LogLog.debug("Setting category factory to [" + string + "].");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.log4j.spi.LoggerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.loggerFactory = (LoggerFactory)OptionConverter.instantiateByClassName(string, clazz, this.loggerFactory);
            PropertySetter.setProperties(this.loggerFactory, properties, "log4j.factory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configureRootCategory(Properties properties, LoggerRepository loggerRepository) {
        String string = ROOT_LOGGER_PREFIX;
        String string2 = OptionConverter.findAndSubst(ROOT_LOGGER_PREFIX, properties);
        if (string2 == null) {
            string2 = OptionConverter.findAndSubst(ROOT_CATEGORY_PREFIX, properties);
            string = ROOT_CATEGORY_PREFIX;
        }
        if (string2 == null) {
            LogLog.debug("Could not find root logger information. Is this OK?");
        } else {
            Logger logger;
            Logger logger2 = logger = loggerRepository.getRootLogger();
            synchronized (logger2) {
                this.parseCategory(properties, logger, string, INTERNAL_ROOT_NAME, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCatsAndRenderers(Properties properties, LoggerRepository loggerRepository) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            String string = (String)enumeration.nextElement();
            if (string.startsWith(CATEGORY_PREFIX) || string.startsWith(LOGGER_PREFIX)) {
                Logger logger;
                object2 = null;
                if (string.startsWith(CATEGORY_PREFIX)) {
                    object2 = string.substring(CATEGORY_PREFIX.length());
                } else if (string.startsWith(LOGGER_PREFIX)) {
                    object2 = string.substring(LOGGER_PREFIX.length());
                }
                object = OptionConverter.findAndSubst(string, properties);
                Logger logger2 = logger = loggerRepository.getLogger((String)object2, this.loggerFactory);
                synchronized (logger2) {
                    this.parseCategory(properties, logger, string, (String)object2, (String)object);
                    this.parseAdditivityForLogger(properties, logger, (String)object2);
                    continue;
                }
            }
            if (string.startsWith(RENDERER_PREFIX)) {
                object2 = string.substring(RENDERER_PREFIX.length());
                object = OptionConverter.findAndSubst(string, properties);
                if (!(loggerRepository instanceof RendererSupport)) continue;
                RendererMap.addRenderer((RendererSupport)((Object)loggerRepository), (String)object2, (String)object);
                continue;
            }
            if (!string.equals(THROWABLE_RENDERER_PREFIX) || !(loggerRepository instanceof ThrowableRendererSupport)) continue;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.apache.log4j.spi.ThrowableRenderer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((object2 = (ThrowableRenderer)OptionConverter.instantiateByKey(properties, THROWABLE_RENDERER_PREFIX, clazz, null)) == null) {
                LogLog.error("Could not instantiate throwableRenderer.");
                continue;
            }
            object = new PropertySetter(object2);
            ((PropertySetter)object).setProperties(properties, "log4j.throwableRenderer.");
            ((ThrowableRendererSupport)((Object)loggerRepository)).setThrowableRenderer((ThrowableRenderer)object2);
        }
    }

    void parseAdditivityForLogger(Properties properties, Logger logger, String string) {
        String string2 = OptionConverter.findAndSubst(ADDITIVITY_PREFIX + string, properties);
        LogLog.debug("Handling log4j.additivity." + string + "=[" + string2 + "]");
        if (string2 != null && !string2.equals("")) {
            boolean bl = OptionConverter.toBoolean(string2, true);
            LogLog.debug("Setting additivity for \"" + string + "\" to " + bl);
            logger.setAdditivity(bl);
        }
    }

    void parseCategory(Properties properties, Logger logger, String string, String string2, String string3) {
        Object object;
        LogLog.debug("Parsing for [" + string2 + "] with value=[" + string3 + "].");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        if (!string3.startsWith(",") && !string3.equals("")) {
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            object = stringTokenizer.nextToken();
            LogLog.debug("Level token is [" + (String)object + "].");
            if ("inherited".equalsIgnoreCase((String)object) || "null".equalsIgnoreCase((String)object)) {
                if (string2.equals(INTERNAL_ROOT_NAME)) {
                    LogLog.warn("The root logger cannot be set to null.");
                } else {
                    logger.setLevel(null);
                }
            } else {
                logger.setLevel(OptionConverter.toLevel((String)object, Level.DEBUG));
            }
            LogLog.debug("Category " + string2 + " set to " + logger.getLevel());
        }
        logger.removeAllAppenders();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            if (string4 == null || string4.equals(",")) continue;
            LogLog.debug("Parsing appender named \"" + string4 + "\".");
            object = this.parseAppender(properties, string4);
            if (object == null) continue;
            logger.addAppender((Appender)object);
        }
    }

    Appender parseAppender(Properties properties, String string) {
        Appender appender = this.registryGet(string);
        if (appender != null) {
            LogLog.debug("Appender \"" + string + "\" was already parsed.");
            return appender;
        }
        String string2 = APPENDER_PREFIX + string;
        String string3 = String.valueOf(string2) + ".layout";
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.apache.log4j.Appender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((appender = (Appender)OptionConverter.instantiateByKey(properties, string2, clazz, null)) == null) {
            LogLog.error("Could not instantiate appender named \"" + string + "\".");
            return null;
        }
        appender.setName(string);
        if (appender instanceof OptionHandler) {
            String string4;
            Object object;
            if (appender.requiresLayout()) {
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("org.apache.log4j.Layout");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((object = (Layout)OptionConverter.instantiateByKey(properties, string3, clazz2, null)) != null) {
                    appender.setLayout((Layout)object);
                    LogLog.debug("Parsing layout options for \"" + string + "\".");
                    PropertySetter.setProperties(object, properties, String.valueOf(string3) + ".");
                    LogLog.debug("End of parsing for \"" + string + "\".");
                }
            }
            if ((string4 = OptionConverter.findAndSubst((String)(object = String.valueOf(string2) + ".errorhandler"), properties)) != null) {
                ErrorHandler errorHandler;
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("org.apache.log4j.spi.ErrorHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((errorHandler = (ErrorHandler)OptionConverter.instantiateByKey(properties, (String)object, clazz3, null)) != null) {
                    appender.setErrorHandler(errorHandler);
                    LogLog.debug("Parsing errorhandler options for \"" + string + "\".");
                    this.parseErrorHandler(errorHandler, (String)object, properties, this.repository);
                    Properties properties2 = new Properties();
                    String[] stringArray = new String[]{String.valueOf(object) + "." + ROOT_REF, String.valueOf(object) + "." + LOGGER_REF, String.valueOf(object) + "." + APPENDER_REF_TAG};
                    Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Object, Object> entry = iterator.next();
                        int n = 0;
                        while (n < stringArray.length) {
                            if (stringArray[n].equals(entry.getKey())) break;
                            ++n;
                        }
                        if (n != stringArray.length) continue;
                        properties2.put(entry.getKey(), entry.getValue());
                    }
                    PropertySetter.setProperties(errorHandler, properties2, String.valueOf(object) + ".");
                    LogLog.debug("End of errorhandler parsing for \"" + string + "\".");
                }
            }
            PropertySetter.setProperties(appender, properties, String.valueOf(string2) + ".");
            LogLog.debug("Parsed \"" + string + "\" options.");
        }
        this.parseAppenderFilters(properties, string, appender);
        this.registryPut(appender);
        return appender;
    }

    private void parseErrorHandler(ErrorHandler errorHandler, String string, Properties properties, LoggerRepository loggerRepository) {
        Appender appender;
        Object object;
        String string2;
        boolean bl = OptionConverter.toBoolean(OptionConverter.findAndSubst(String.valueOf(string) + ROOT_REF, properties), false);
        if (bl) {
            errorHandler.setLogger(loggerRepository.getRootLogger());
        }
        if ((string2 = OptionConverter.findAndSubst(String.valueOf(string) + LOGGER_REF, properties)) != null) {
            object = this.loggerFactory == null ? loggerRepository.getLogger(string2) : loggerRepository.getLogger(string2, this.loggerFactory);
            errorHandler.setLogger((Logger)object);
        }
        if ((object = OptionConverter.findAndSubst(String.valueOf(string) + APPENDER_REF_TAG, properties)) != null && (appender = this.parseAppender(properties, (String)object)) != null) {
            errorHandler.setBackupAppender(appender);
        }
    }

    void parseAppenderFilters(Properties properties, String string, Appender appender) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = APPENDER_PREFIX + string + ".filter.";
        int n = string2.length();
        Hashtable hashtable = new Hashtable();
        Enumeration<Object> enumeration = properties.keys();
        String string3 = "";
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            if (!((String)object4).startsWith(string2)) continue;
            int n2 = ((String)object4).indexOf(46, n);
            object3 = object4;
            if (n2 != -1) {
                object3 = ((String)object4).substring(0, n2);
                string3 = ((String)object4).substring(n2 + 1);
            }
            if ((object2 = (Vector<NameValue>)hashtable.get(object3)) == null) {
                object2 = new Vector<NameValue>();
                hashtable.put(object3, object2);
            }
            if (n2 == -1) continue;
            object = OptionConverter.findAndSubst((String)object4, properties);
            ((Vector)object2).add(new NameValue(string3, (String)object));
        }
        object4 = new SortedKeyEnumeration(hashtable);
        while (object4.hasMoreElements()) {
            String string4 = (String)object4.nextElement();
            object3 = properties.getProperty(string4);
            if (object3 != null) {
                LogLog.debug("Filter key: [" + string4 + "] class: [" + properties.getProperty(string4) + "] props: " + hashtable.get(string4));
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.apache.log4j.spi.Filter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((object2 = (Filter)OptionConverter.instantiateByClassName((String)object3, clazz, null)) == null) continue;
                object = new PropertySetter(object2);
                Vector vector = (Vector)hashtable.get(string4);
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    NameValue nameValue = (NameValue)enumeration2.nextElement();
                    ((PropertySetter)object).setProperty(nameValue.key, nameValue.value);
                }
                ((PropertySetter)object).activate();
                LogLog.debug("Adding filter of type [" + object2.getClass() + "] to appender named [" + appender.getName() + "].");
                appender.addFilter((Filter)object2);
                continue;
            }
            LogLog.warn("Missing class definition for filter: [" + string4 + "]");
        }
    }

    void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    Appender registryGet(String string) {
        return (Appender)this.registry.get(string);
    }
}

