/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class ThrowableInformationPatternConverter
extends LoggingEventPatternConverter {
    private int maxLines = Integer.MAX_VALUE;

    private ThrowableInformationPatternConverter(String[] stringArray) {
        super("Throwable", "throwable");
        if (stringArray != null && stringArray.length > 0) {
            if ("none".equals(stringArray[0])) {
                this.maxLines = 0;
            } else if ("short".equals(stringArray[0])) {
                this.maxLines = 1;
            } else {
                try {
                    this.maxLines = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public static ThrowableInformationPatternConverter newInstance(String[] stringArray) {
        return new ThrowableInformationPatternConverter(stringArray);
    }

    public void format(LoggingEvent loggingEvent, StringBuffer stringBuffer) {
        ThrowableInformation throwableInformation;
        if (this.maxLines != 0 && (throwableInformation = loggingEvent.getThrowableInformation()) != null) {
            String[] stringArray = throwableInformation.getThrowableStrRep();
            int n = stringArray.length;
            if (this.maxLines < 0) {
                n += this.maxLines;
            } else if (n > this.maxLines) {
                n = this.maxLines;
            }
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                stringBuffer.append(string).append("\n");
                ++n2;
            }
        }
    }

    public boolean handlesThrowable() {
        return true;
    }
}

