/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.PatternConverter;

public final class PatternParser {
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    private static final Map PATTERN_LAYOUT_RULES;
    private static final Map FILENAME_PATTERN_RULES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;

    static {
        HashMap hashMap = new HashMap(17);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.log4j.pattern.LoggerPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("c", clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.log4j.pattern.LoggerPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("logger", clazz2);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.apache.log4j.pattern.ClassNamePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("C", clazz3);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.apache.log4j.pattern.ClassNamePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("class", clazz4);
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("org.apache.log4j.pattern.DatePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("d", clazz5);
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("org.apache.log4j.pattern.DatePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("date", clazz6);
        Class<?> clazz7 = class$3;
        if (clazz7 == null) {
            try {
                clazz7 = class$3 = Class.forName("org.apache.log4j.pattern.FileLocationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("F", clazz7);
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("org.apache.log4j.pattern.FileLocationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("file", clazz8);
        Class<?> clazz9 = class$4;
        if (clazz9 == null) {
            try {
                clazz9 = class$4 = Class.forName("org.apache.log4j.pattern.FullLocationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("l", clazz9);
        Class<?> clazz10 = class$5;
        if (clazz10 == null) {
            try {
                clazz10 = class$5 = Class.forName("org.apache.log4j.pattern.LineLocationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("L", clazz10);
        Class<?> clazz11 = class$5;
        if (clazz11 == null) {
            try {
                clazz11 = class$5 = Class.forName("org.apache.log4j.pattern.LineLocationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("line", clazz11);
        Class<?> clazz12 = class$6;
        if (clazz12 == null) {
            try {
                clazz12 = class$6 = Class.forName("org.apache.log4j.pattern.MessagePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("m", clazz12);
        Class<?> clazz13 = class$6;
        if (clazz13 == null) {
            try {
                clazz13 = class$6 = Class.forName("org.apache.log4j.pattern.MessagePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("message", clazz13);
        Class<?> clazz14 = class$7;
        if (clazz14 == null) {
            try {
                clazz14 = class$7 = Class.forName("org.apache.log4j.pattern.LineSeparatorPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("n", clazz14);
        Class<?> clazz15 = class$8;
        if (clazz15 == null) {
            try {
                clazz15 = class$8 = Class.forName("org.apache.log4j.pattern.MethodLocationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("M", clazz15);
        Class<?> clazz16 = class$8;
        if (clazz16 == null) {
            try {
                clazz16 = class$8 = Class.forName("org.apache.log4j.pattern.MethodLocationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("method", clazz16);
        Class<?> clazz17 = class$9;
        if (clazz17 == null) {
            try {
                clazz17 = class$9 = Class.forName("org.apache.log4j.pattern.LevelPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("p", clazz17);
        Class<?> clazz18 = class$9;
        if (clazz18 == null) {
            try {
                clazz18 = class$9 = Class.forName("org.apache.log4j.pattern.LevelPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("level", clazz18);
        Class<?> clazz19 = class$10;
        if (clazz19 == null) {
            try {
                clazz19 = class$10 = Class.forName("org.apache.log4j.pattern.RelativeTimePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("r", clazz19);
        Class<?> clazz20 = class$10;
        if (clazz20 == null) {
            try {
                clazz20 = class$10 = Class.forName("org.apache.log4j.pattern.RelativeTimePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("relative", clazz20);
        Class<?> clazz21 = class$11;
        if (clazz21 == null) {
            try {
                clazz21 = class$11 = Class.forName("org.apache.log4j.pattern.ThreadPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("t", clazz21);
        Class<?> clazz22 = class$11;
        if (clazz22 == null) {
            try {
                clazz22 = class$11 = Class.forName("org.apache.log4j.pattern.ThreadPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("thread", clazz22);
        Class<?> clazz23 = class$12;
        if (clazz23 == null) {
            try {
                clazz23 = class$12 = Class.forName("org.apache.log4j.pattern.NDCPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("x", clazz23);
        Class<?> clazz24 = class$12;
        if (clazz24 == null) {
            try {
                clazz24 = class$12 = Class.forName("org.apache.log4j.pattern.NDCPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("ndc", clazz24);
        Class<?> clazz25 = class$13;
        if (clazz25 == null) {
            try {
                clazz25 = class$13 = Class.forName("org.apache.log4j.pattern.PropertiesPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("X", clazz25);
        Class<?> clazz26 = class$13;
        if (clazz26 == null) {
            try {
                clazz26 = class$13 = Class.forName("org.apache.log4j.pattern.PropertiesPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("properties", clazz26);
        Class<?> clazz27 = class$14;
        if (clazz27 == null) {
            try {
                clazz27 = class$14 = Class.forName("org.apache.log4j.pattern.SequenceNumberPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("sn", clazz27);
        Class<?> clazz28 = class$14;
        if (clazz28 == null) {
            try {
                clazz28 = class$14 = Class.forName("org.apache.log4j.pattern.SequenceNumberPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("sequenceNumber", clazz28);
        Class<?> clazz29 = class$15;
        if (clazz29 == null) {
            try {
                clazz29 = class$15 = Class.forName("org.apache.log4j.pattern.ThrowableInformationPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap.put("throwable", clazz29);
        PATTERN_LAYOUT_RULES = new ReadOnlyMap(hashMap);
        HashMap hashMap2 = new HashMap(4);
        Class<?> clazz30 = class$16;
        if (clazz30 == null) {
            try {
                clazz30 = class$16 = Class.forName("org.apache.log4j.pattern.FileDatePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap2.put("d", clazz30);
        Class<?> clazz31 = class$16;
        if (clazz31 == null) {
            try {
                clazz31 = class$16 = Class.forName("org.apache.log4j.pattern.FileDatePatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap2.put("date", clazz31);
        Class<?> clazz32 = class$17;
        if (clazz32 == null) {
            try {
                clazz32 = class$17 = Class.forName("org.apache.log4j.pattern.IntegerPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap2.put("i", clazz32);
        Class<?> clazz33 = class$17;
        if (clazz33 == null) {
            try {
                clazz33 = class$17 = Class.forName("org.apache.log4j.pattern.IntegerPatternConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        hashMap2.put("index", clazz33);
        FILENAME_PATTERN_RULES = new ReadOnlyMap(hashMap2);
    }

    private PatternParser() {
    }

    public static Map getPatternLayoutRules() {
        return PATTERN_LAYOUT_RULES;
    }

    public static Map getFileNamePatternRules() {
        return FILENAME_PATTERN_RULES;
    }

    private static int extractConverter(char c, String string, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        stringBuffer.setLength(0);
        if (!Character.isUnicodeIdentifierStart(c)) {
            return n;
        }
        stringBuffer.append(c);
        while (n < string.length() && Character.isUnicodeIdentifierPart(string.charAt(n))) {
            stringBuffer.append(string.charAt(n));
            stringBuffer2.append(string.charAt(n));
            ++n;
        }
        return n;
    }

    private static int extractOptions(String string, int n, List list) {
        while (n < string.length() && string.charAt(n) == '{') {
            int n2 = string.indexOf(125, n);
            if (n2 == -1) break;
            String string2 = string.substring(n + 1, n2);
            list.add(string2);
            n = n2 + 1;
        }
        return n;
    }

    public static void parse(String string, List list, List list2, Map map, Map map2) {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        FormattingInfo formattingInfo = FormattingInfo.getDefault();
        while (n3 < n) {
            char c = string.charAt(n3++);
            block0 : switch (n2) {
                case 0: {
                    if (n3 == n) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (c == '%') {
                        switch (string.charAt(n3)) {
                            case '%': {
                                stringBuffer.append(c);
                                ++n3;
                                break block0;
                            }
                        }
                        if (stringBuffer.length() != 0) {
                            list.add(new LiteralPatternConverter(stringBuffer.toString()));
                            list2.add(FormattingInfo.getDefault());
                        }
                        stringBuffer.setLength(0);
                        stringBuffer.append(c);
                        n2 = 1;
                        formattingInfo = FormattingInfo.getDefault();
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 1: {
                    stringBuffer.append(c);
                    switch (c) {
                        case '-': {
                            formattingInfo = new FormattingInfo(true, formattingInfo.getMinLength(), formattingInfo.getMaxLength());
                            break block0;
                        }
                        case '.': {
                            n2 = 3;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), c - 48, formattingInfo.getMaxLength());
                        n2 = 4;
                        break;
                    }
                    n3 = PatternParser.finalizeConverter(c, string, n3, stringBuffer, formattingInfo, map, map2, list, list2);
                    n2 = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuffer.setLength(0);
                    break;
                }
                case 4: {
                    stringBuffer.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength() * 10 + (c - 48), formattingInfo.getMaxLength());
                        break;
                    }
                    if (c == '.') {
                        n2 = 3;
                        break;
                    }
                    n3 = PatternParser.finalizeConverter(c, string, n3, stringBuffer, formattingInfo, map, map2, list, list2);
                    n2 = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuffer.setLength(0);
                    break;
                }
                case 3: {
                    stringBuffer.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), c - 48);
                        n2 = 5;
                        break;
                    }
                    LogLog.error("Error occured in position " + n3 + ".\n Was expecting digit, instead got char \"" + c + "\".");
                    n2 = 0;
                    break;
                }
                case 5: {
                    stringBuffer.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength() * 10 + (c - 48));
                        break;
                    }
                    n3 = PatternParser.finalizeConverter(c, string, n3, stringBuffer, formattingInfo, map, map2, list, list2);
                    n2 = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuffer.setLength(0);
                }
            }
        }
        if (stringBuffer.length() != 0) {
            list.add(new LiteralPatternConverter(stringBuffer.toString()));
            list2.add(FormattingInfo.getDefault());
        }
    }

    private static PatternConverter createConverter(String string, StringBuffer stringBuffer, Map map, Map map2, List list) {
        String string2 = string;
        Object var6_6 = null;
        int n = string.length();
        while (n > 0 && var6_6 == null) {
            string2 = string2.substring(0, n);
            if (map != null) {
                var6_6 = map.get(string2);
            }
            if (var6_6 == null && map2 != null) {
                var6_6 = map2.get(string2);
            }
            --n;
        }
        if (var6_6 == null) {
            LogLog.error("Unrecognized format specifier [" + string + "]");
            return null;
        }
        Class clazz = null;
        if (var6_6 instanceof Class) {
            clazz = var6_6;
        } else if (var6_6 instanceof String) {
            try {
                clazz = Loader.loadClass(var6_6);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogLog.warn("Class for conversion pattern %" + string2 + " not found", classNotFoundException);
                return null;
            }
        } else {
            LogLog.warn("Bad map entry for conversion pattern %" + string2 + ".");
            return null;
        }
        try {
            Method method = clazz.getMethod("newInstance", Class.forName("[Ljava.lang.String;"));
            String[] stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
            Object object = method.invoke(null, new Object[]{stringArray});
            if (object instanceof PatternConverter) {
                stringBuffer.delete(0, stringBuffer.length() - (string.length() - string2.length()));
                return (PatternConverter)object;
            }
            LogLog.warn("Class " + clazz.getName() + " does not extend PatternConverter.");
        }
        catch (Exception exception) {
            LogLog.error("Error creating converter for " + string, exception);
            try {
                PatternConverter patternConverter = (PatternConverter)clazz.newInstance();
                stringBuffer.delete(0, stringBuffer.length() - (string.length() - string2.length()));
                return patternConverter;
            }
            catch (Exception exception2) {
                LogLog.error("Error creating converter for " + string, exception2);
            }
        }
        return null;
    }

    private static int finalizeConverter(char c, String string, int n, StringBuffer stringBuffer, FormattingInfo formattingInfo, Map map, Map map2, List list, List list2) {
        StringBuffer stringBuffer2 = new StringBuffer();
        n = PatternParser.extractConverter(c, string, n, stringBuffer2, stringBuffer);
        String string2 = stringBuffer2.toString();
        ArrayList arrayList = new ArrayList();
        n = PatternParser.extractOptions(string, n, arrayList);
        PatternConverter patternConverter = PatternParser.createConverter(string2, stringBuffer, map, map2, arrayList);
        if (patternConverter == null) {
            StringBuffer stringBuffer3;
            if (string2 == null || string2.length() == 0) {
                stringBuffer3 = new StringBuffer("Empty conversion specifier starting at position ");
            } else {
                stringBuffer3 = new StringBuffer("Unrecognized conversion specifier [");
                stringBuffer3.append(string2);
                stringBuffer3.append("] starting at position ");
            }
            stringBuffer3.append(Integer.toString(n));
            stringBuffer3.append(" in conversion pattern.");
            LogLog.error(stringBuffer3.toString());
            list.add(new LiteralPatternConverter(stringBuffer.toString()));
            list2.add(FormattingInfo.getDefault());
        } else {
            list.add(patternConverter);
            list2.add(formattingInfo);
            if (stringBuffer.length() > 0) {
                list.add(new LiteralPatternConverter(stringBuffer.toString()));
                list2.add(FormattingInfo.getDefault());
            }
        }
        stringBuffer.setLength(0);
        return n;
    }

    private static class ReadOnlyMap
    implements Map {
        private final Map map;

        public ReadOnlyMap(Map map) {
            this.map = map;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public Object get(Object object) {
            return this.map.get(object);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }

        public Collection values() {
            return this.map.values();
        }
    }
}

