/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public final class BridgePatternConverter
extends PatternConverter {
    private LoggingEventPatternConverter[] patternConverters;
    private FormattingInfo[] patternFields;
    private boolean handlesExceptions;

    public BridgePatternConverter(String string) {
        this.next = null;
        this.handlesExceptions = false;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Map map = null;
        PatternParser.parse(string, arrayList, arrayList2, map, PatternParser.getPatternLayoutRules());
        this.patternConverters = new LoggingEventPatternConverter[arrayList.size()];
        this.patternFields = new FormattingInfo[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof LoggingEventPatternConverter) {
                this.patternConverters[n] = (LoggingEventPatternConverter)e;
                this.handlesExceptions |= this.patternConverters[n].handlesThrowable();
            } else {
                this.patternConverters[n] = new LiteralPatternConverter("");
            }
            this.patternFields[n] = iterator2.hasNext() ? (FormattingInfo)iterator2.next() : FormattingInfo.getDefault();
            ++n;
        }
    }

    protected String convert(LoggingEvent loggingEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        this.format(stringBuffer, loggingEvent);
        return stringBuffer.toString();
    }

    public void format(StringBuffer stringBuffer, LoggingEvent loggingEvent) {
        int n = 0;
        while (n < this.patternConverters.length) {
            int n2 = stringBuffer.length();
            this.patternConverters[n].format(loggingEvent, stringBuffer);
            this.patternFields[n].format(n2, stringBuffer);
            ++n;
        }
    }

    public boolean ignoresThrowable() {
        return !this.handlesExceptions;
    }
}

