/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class TelnetAppender
extends AppenderSkeleton {
    private SocketHandler sh;
    private int port = 23;

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            this.sh = new SocketHandler(this.port);
            this.sh.start();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            interruptedIOException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        super.activateOptions();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void close() {
        if (this.sh != null) {
            this.sh.close();
            try {
                this.sh.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void append(LoggingEvent loggingEvent) {
        if (this.sh != null) {
            String[] stringArray;
            this.sh.send(this.layout.format(loggingEvent));
            if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append("\r\n");
                    ++n;
                }
                this.sh.send(stringBuffer.toString());
            }
        }
    }

    protected class SocketHandler
    extends Thread {
        private Vector writers = new Vector();
        private Vector connections = new Vector();
        private ServerSocket serverSocket;
        private int MAX_CONNECTIONS = 20;

        public void finalize() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            SocketHandler socketHandler = this;
            synchronized (socketHandler) {
                Enumeration enumeration = this.connections.elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        ((Socket)enumeration.nextElement()).close();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException iOException) {
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {}
        }

        public synchronized void send(String string) {
            Iterator iterator = this.connections.iterator();
            Iterator iterator2 = this.writers.iterator();
            while (iterator2.hasNext()) {
                iterator.next();
                PrintWriter printWriter = (PrintWriter)iterator2.next();
                printWriter.print(string);
                if (!printWriter.checkError()) continue;
                iterator.remove();
                iterator2.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
                    if (this.connections.size() < this.MAX_CONNECTIONS) {
                        SocketHandler socketHandler = this;
                        synchronized (socketHandler) {
                            this.connections.addElement(socket);
                            this.writers.addElement(printWriter);
                            printWriter.print("TelnetAppender v1.0 (" + this.connections.size() + " active connections)\r\n\r\n");
                            printWriter.flush();
                            continue;
                        }
                    }
                    printWriter.print("Too many connections.\r\n");
                    printWriter.flush();
                    socket.close();
                }
                catch (Exception exception) {
                    if (exception instanceof InterruptedIOException || exception instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (this.serverSocket.isClosed()) break;
                    LogLog.error("Encountered error while in SocketHandler loop.", exception);
                    break;
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
            }
            catch (IOException iOException) {}
        }

        public SocketHandler(int n) throws IOException {
            this.serverSocket = new ServerSocket(n);
            this.setName("TelnetAppender-" + this.getName() + "-" + n);
        }
    }
}

