/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.LogRecordFilter;
import org.apache.log4j.lf5.PassingLogRecordFilter;

public class FilteredLogTableModel
extends AbstractTableModel {
    protected LogRecordFilter _filter = new PassingLogRecordFilter();
    protected List _allRecords = new ArrayList();
    protected List _filteredRecords;
    protected int _maxNumberOfLogRecords = 5000;
    protected String[] _colNames = new String[]{"Date", "Thread", "Message #", "Level", "NDC", "Category", "Message", "Location", "Thrown"};

    public void setLogRecordFilter(LogRecordFilter logRecordFilter) {
        this._filter = logRecordFilter;
    }

    public LogRecordFilter getLogRecordFilter() {
        return this._filter;
    }

    public String getColumnName(int n) {
        return this._colNames[n];
    }

    public int getColumnCount() {
        return this._colNames.length;
    }

    public int getRowCount() {
        return this.getFilteredRecords().size();
    }

    public int getTotalRowCount() {
        return this._allRecords.size();
    }

    public Object getValueAt(int n, int n2) {
        LogRecord logRecord = this.getFilteredRecord(n);
        return this.getColumn(n2, logRecord);
    }

    public void setMaxNumberOfLogRecords(int n) {
        if (n > 0) {
            this._maxNumberOfLogRecords = n;
        }
    }

    public synchronized boolean addLogRecord(LogRecord logRecord) {
        this._allRecords.add(logRecord);
        if (!this._filter.passes(logRecord)) {
            return false;
        }
        this.getFilteredRecords().add(logRecord);
        this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        this.trimRecords();
        return true;
    }

    public synchronized void refresh() {
        this._filteredRecords = this.createFilteredRecordsList();
        this.fireTableDataChanged();
    }

    public synchronized void fastRefresh() {
        this._filteredRecords.remove(0);
        this.fireTableRowsDeleted(0, 0);
    }

    public synchronized void clear() {
        this._allRecords.clear();
        this._filteredRecords.clear();
        this.fireTableDataChanged();
    }

    protected List getFilteredRecords() {
        if (this._filteredRecords == null) {
            this.refresh();
        }
        return this._filteredRecords;
    }

    protected List createFilteredRecordsList() {
        ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>();
        Iterator iterator = this._allRecords.iterator();
        while (iterator.hasNext()) {
            LogRecord logRecord = (LogRecord)iterator.next();
            if (!this._filter.passes(logRecord)) continue;
            arrayList.add(logRecord);
        }
        return arrayList;
    }

    protected LogRecord getFilteredRecord(int n) {
        List list = this.getFilteredRecords();
        int n2 = list.size();
        if (n < n2) {
            return (LogRecord)list.get(n);
        }
        return (LogRecord)list.get(n2 - 1);
    }

    protected Object getColumn(int n, LogRecord logRecord) {
        if (logRecord == null) {
            return "NULL Column";
        }
        String string = new Date(logRecord.getMillis()).toString();
        switch (n) {
            case 0: {
                return String.valueOf(string) + " (" + logRecord.getMillis() + ")";
            }
            case 1: {
                return logRecord.getThreadDescription();
            }
            case 2: {
                return new Long(logRecord.getSequenceNumber());
            }
            case 3: {
                return logRecord.getLevel();
            }
            case 4: {
                return logRecord.getNDC();
            }
            case 5: {
                return logRecord.getCategory();
            }
            case 6: {
                return logRecord.getMessage();
            }
            case 7: {
                return logRecord.getLocation();
            }
            case 8: {
                return logRecord.getThrownStackTrace();
            }
        }
        String string2 = "The column number " + n + "must be between 0 and 8";
        throw new IllegalArgumentException(string2);
    }

    protected void trimRecords() {
        if (this.needsTrimming()) {
            this.trimOldestRecords();
        }
    }

    protected boolean needsTrimming() {
        return this._allRecords.size() > this._maxNumberOfLogRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trimOldestRecords() {
        List list = this._allRecords;
        synchronized (list) {
            int n = this.numberOfRecordsToTrim();
            if (n > 1) {
                List list2 = this._allRecords.subList(0, n);
                list2.clear();
                this.refresh();
            } else {
                this._allRecords.remove(0);
                this.fastRefresh();
            }
        }
    }

    private int numberOfRecordsToTrim() {
        return this._allRecords.size() - this._maxNumberOfLogRecords;
    }
}

