/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.log4j.lf5.LogLevel;

public abstract class LogRecord
implements Serializable {
    protected static long _seqCount = 0L;
    protected LogLevel _level;
    protected String _message = "";
    protected long _sequenceNumber;
    protected long _millis = System.currentTimeMillis();
    protected String _category = "Debug";
    protected String _thread;
    protected String _thrownStackTrace;
    protected Throwable _thrown;
    protected String _ndc = "";
    protected String _location = "";

    public LogRecord() {
        this._level = LogLevel.INFO;
        this._sequenceNumber = LogRecord.getNextId();
        this._thread = Thread.currentThread().toString();
    }

    public LogLevel getLevel() {
        return this._level;
    }

    public void setLevel(LogLevel logLevel) {
        this._level = logLevel;
    }

    public abstract boolean isSevereLevel();

    public boolean hasThrown() {
        Throwable throwable = this.getThrown();
        if (throwable == null) {
            return false;
        }
        String string = throwable.toString();
        return string != null && string.trim().length() != 0;
    }

    public boolean isFatal() {
        return this.isSevereLevel() || this.hasThrown();
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String string) {
        this._category = string;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String string) {
        this._message = string;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this._sequenceNumber = l;
    }

    public long getMillis() {
        return this._millis;
    }

    public void setMillis(long l) {
        this._millis = l;
    }

    public String getThreadDescription() {
        return this._thread;
    }

    public void setThreadDescription(String string) {
        this._thread = string;
    }

    public String getThrownStackTrace() {
        return this._thrownStackTrace;
    }

    public void setThrownStackTrace(String string) {
        this._thrownStackTrace = string;
    }

    public Throwable getThrown() {
        return this._thrown;
    }

    public void setThrown(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this._thrown = throwable;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        this._thrownStackTrace = stringWriter.toString();
        try {
            printWriter.close();
            stringWriter.close();
        }
        catch (IOException iOException) {}
        printWriter = null;
        stringWriter = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LogRecord: [" + this._level + ", " + this._message + "]");
        return stringBuffer.toString();
    }

    public String getNDC() {
        return this._ndc;
    }

    public void setNDC(String string) {
        this._ndc = string;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String string) {
        this._location = string;
    }

    public static synchronized void resetSequenceNumber() {
        _seqCount = 0L;
    }

    protected static synchronized long getNextId() {
        return ++_seqCount;
    }
}

